import xbmcplugin
import xbmcgui
import xbmcaddon
import xbmc
import requests
import sys
import re
from urllib.parse import urlparse, parse_qs

# Parametros iniciales del plugin
addon = xbmcaddon.Addon()
addon_handle = int(sys.argv[1])
base_url = "https://cumxtv.ddns.net/lista.m3u"

# Cargar la lista M3U
def load_m3u():
    try:
        xbmc.log("Cargando lista M3U desde: " + base_url, xbmc.LOGINFO)
        response = requests.get(base_url)
        response.raise_for_status()
        return parse_m3u(response.text)
    except requests.exceptions.RequestException as e:
        xbmc.log("Error cargando lista M3U: " + str(e), xbmc.LOGDEBUG)
        xbmcgui.Dialog().notification("Error", "No se pudo cargar la lista M3U", xbmcgui.NOTIFICATION_ERROR)
        return []

# Parsear el contenido M3U y obtener los canales
def parse_m3u(m3u_content):
    channels = []
    lines = m3u_content.splitlines()
    for i in range(len(lines)):
        if lines[i].startswith("#EXTINF"):
            try:
                name = re.search(r',(.+)', lines[i]).group(1)
                url = lines[i + 1].strip()
                channels.append((name, url))
            except (IndexError, AttributeError):
                xbmc.log("Error parseando la lista M3U en la línea: " + str(i), xbmc.LOGERROR)
    return channels

# Mostrar los canales en el menu de Kodi
def list_channels():
    channels = load_m3u()  # Cargar la lista M3U
    if not channels:
        xbmcgui.Dialog().notification("Error", "No se encontraron canales para mostrar", xbmcgui.NOTIFICATION_ERROR)
        return
    
    try:
        for name, url in channels:
            list_item = xbmcgui.ListItem(label=name)
            list_item.setInfo("video", {"title": name})
            list_item.setProperty("IsPlayable", "true")
            
            if not url:  # Verificar si la URL es válida
                xbmc.log("URL inválida para el canal: " + name, xbmc.LOGERROR)
                continue
            
            xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=list_item, isFolder=False)
        xbmcplugin.endOfDirectory(addon_handle)
    except Exception as e:
        xbmc.log("Error mostrando los canales: " + str(e), xbmc.LOGERROR)

# Manejar los parametros del plugin
def get_params():
    if len(sys.argv) > 2:
        query = sys.argv[2][1:]  # Obtener parametros desde argv
        return dict(parse_qs(query))
    else:
        return {}

# Punto de entrada
if __name__ == '__main__':
    params = get_params()
    xbmc.log("Iniciando el plugin con parámetros: " + str(params), xbmc.LOGDEBUG)
    if not params:
        list_channels()